#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#include "RS232com1.h" 
#include "CP56messageDecode.h"
#include "options.h" 
#include "main.h"


uint8_t msgFSMstate ;

#define msgFSMresetState 0

#define msgFSMfirst68scanned 1
#define msgFSMfirstLengthscanned 2
#define msgFSMsecondLengthscanned 3
#define msgFSMsecond68scanned 4

#define msgBufferLength 32 

uint8_t msgBuffer[msgBufferLength] ;
uint8_t firstLength ;

uint8_t secondLength ;
uint8_t payloadBytes ;
uint8_t chkSum ;
uint8_t waitingForGap ;
uint16_t gapCount ;
uint8_t crWasThere ;

uint16_t okCount ;

void msgFSMreset1(){
  msgFSMstate =msgFSMresetState ;
  payloadBytes=0 ;
  chkSum=0 ;
  }

void msgFSMinit() {
  okCount=0 ;
  msgFSMreset1() ;
  }


#define parityERROR 1
#define wrongStartERROR 2
#define lengthMatchERROR 3
#define missingSecond68ERROR 4
#define chksumERROR 5
#define missing16ERROR 6
#define msgLengthERROR 7

extern uint16_t errorLedTimer ;

void msgFSMerror(uint8_t errorNumber){
  redLedPort |=  _BV(redLedPin) ; 
  waitingForGap=1 ;
  gapCount=0 ;
#ifdef debugOut
  uartPutc('e') ;
  uartByte(errorNumber) ;
  uartBlank() ;
#endif
  msgFSMreset1() ;
  if ( errorLedTimer<16000 ) { errorLedTimer +=50 ; } 
  }



void msgFSMchar(uint8_t theChar, uint8_t parity){
  //uartByte(theChar) ; 
  //if (parity==0){ uartPutc('+') ; } else { uartPutc('-') ; }
  if ( waitingForGap ) { return ; }
  ;
  if (parity != 0) {  
    msgFSMstate =msgFSMresetState ;
	msgFSMerror(parityERROR) ;
	return ; 
	}
  if ( msgFSMstate==msgFSMresetState ){
    chkSum=0 ;
    if ( theChar==0x68){ 
	  msgFSMstate =msgFSMfirst68scanned ;
	  redLedPort &= ~ _BV(redLedPin) ; 
	  return ; 
	  }
	 else{ msgFSMerror(wrongStartERROR) ; return ; }
    }
  if ( msgFSMstate==msgFSMfirst68scanned ){
    firstLength=theChar ;
	msgFSMstate =msgFSMfirstLengthscanned ; 
	return ; 
    }
  if ( msgFSMstate==msgFSMfirstLengthscanned ){
    secondLength=theChar ;
	msgFSMstate =msgFSMsecondLengthscanned ; 
	return ; 
    }
  if ( msgFSMstate==msgFSMsecondLengthscanned  ){
    if ( theChar==0x68){ 
	  msgFSMstate =msgFSMsecond68scanned ; 
	  payloadBytes=0 ; 
	  if ( firstLength != secondLength ){  msgFSMerror(lengthMatchERROR) ;; return ; }
	  //uartPutc('!') ; 
	  return ; 
	  }
    else{ msgFSMerror(missingSecond68ERROR) ;  return ; }
    }
  if ( msgFSMstate==msgFSMsecond68scanned  ){
    // if length==10 there are 16 bytes in total, 4 have already been received here
    // length+2 bytes have to come in here
    msgBuffer[payloadBytes]=theChar ;
	payloadBytes++ ;
    if (payloadBytes<=firstLength){ chkSum=chkSum+theChar ; }

	if (payloadBytes==firstLength+1){
	   //uartPutsPgm(PSTR("=?=")) ; ;uartByte(chkSum) ; uartBlank() ;
    if (chkSum!=theChar){  
#ifdef debugOut
	  uartPutsPgm(PSTR("chkSum err")) ; 
#endif
	  msgFSMerror(chksumERROR) ;
	  }
	}
	if (payloadBytes==firstLength+2){
	  if (theChar != 0x16 ) {   msgFSMerror(missing16ERROR) ; ; return ; }
	  //uartPutc('$') ; 
	  msgFSMstate =msgFSMresetState ;
	  
	  if ( !crWasThere) { 
#ifdef debugOut
	    uartCrlf() ; 
#endif
		}
	  redLedPort |=  _BV(redLedPin) ;
	  //uartPutc('+') ; 
#ifdef debugOut
      okCount++ ;
uartCrlf() ; 
//		uartPutc(0x80+0x40) ;
      //uartDecOut( okCount ) ;
      uartPutsPgm(PSTR("message ok, length=")) ; uartDecOut(firstLength) ; uartBlank() ;
//	  uartCrlf() ; 
	  uartPutsPgm(PSTR(" [")) ;
      for(uint8_t k=0 ; k<payloadBytes ; k++){
	    uartByte(msgBuffer[k]) ;
		uartPutc('_') ;
		}
	  uartPutsPgm(PSTR("] ")) ;
	  // uartPutsPgm(PSTR("             ")) ;
	  #ifdef withCP56
	    if(firstLength==10){ decodeCP56() ; } 
	  #endif
//	  uartCrlf() ;
#endif	   
	  crWasThere=1 ;
	  return ;  
	  }
	if (payloadBytes>firstLength+2){ 
#ifdef debugOut
	  uartPutsPgm(PSTR("msgLength err")) ; ; 
#endif
	  msgFSMerror(msgLengthERROR) ;
	  return ;  
	  }
	}

  }
